/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: HandlerMap.cpp                                                     *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              01/04/2007       1.0                              *
* Carlos Grossy              17/05/2007       1.1                              *
*******************************************************************************/

#include "HandlerMap.h"

handlerMap::handlerMap() { }

handlerMap::~handlerMap() { }

void handlerMap::add(int id, int dscin, int dscout) {

    endp eps;
    if (!exists(id)) {
        eps.dscin = dscin;
        eps.dscout = dscout;
        mapa.insert(pair<int,endp>(id,eps));
    };
}

void handlerMap::remove(int id) {

    if (exists(id)) {
        mapa.erase(id);
    }
}

bool handlerMap::exists(int id) {

    map<int,endp>::iterator it;
    it = mapa.find(id);
    return (it != mapa.end());
}

bool handlerMap::isempty() {

    return (mapa.empty());
}

int handlerMap::getDescriptorSend(int id) {

    endp eps;
    map<int,endp>::iterator it;
    it = mapa.find(id);
    if (it != mapa.end()) {
        eps = it->second;
        return eps.dscout;
    }
    return 0;
}

int handlerMap::getDescriptorRecv(int id) {

    endp eps;
    map<int,endp>::iterator it;
    it = mapa.find(id);
    if (it != mapa.end()) {
        eps = it->second;
        return eps.dscin;
    }
    return 0;
}
